<?php
header('Content-Type: application/json');
include 'db.php';

$order_id = $_GET['order_id'] ?? null;

if (!$order_id) {
    echo json_encode(["status" => "error", "message" => "Order ID is required"]);
    exit;
}

// Escape order_id to prevent SQL injection
$order_id = mysqli_real_escape_string($conn, $order_id);

$response = [
    "status" => "error",
    "message" => "No order found for this ID"
];

$order_query = "
  SELECT 
    o.*,
    i.invoice_no,
    c.displayname,
    c.phoneno,
    c.saddress,
    c.scity,
    c.sstate,
    c.spincode,
    SUM(p.Payment_amount) AS customerpaid
FROM 
    orders o
LEFT JOIN 
    payment p ON o.Order_id = p.Order_id
LEFT JOIN 
    invoice i ON o.Order_id = i.order_id
LEFT JOIN 
    customer c ON o.user_id = c.id
WHERE 
    o.Delete_status = 0 AND o.Order_id = '$order_id'
GROUP BY 
    o.Order_id
ORDER BY 
    o.Created_date DESC;
";

$order_result = mysqli_query($conn, $order_query);

if ($order_result && mysqli_num_rows($order_result) > 0) {
    $order = mysqli_fetch_assoc($order_result);
    
    $order_data_query = "
        SELECT * FROM order_data
        WHERE Order_id = '$order_id' AND Delete_status = 0
    ";

    $order_data_result = mysqli_query($conn, $order_data_query);

    $order_data = [];
    if ($order_data_result && mysqli_num_rows($order_data_result) > 0) {
        while ($data = mysqli_fetch_assoc($order_data_result)) {
            $order_data[] = $data;
        }
    }

    // Fetch payments related to the order
    $paymentsQuery = "
        SELECT
            pc.Payment_date,
            pc.Payment_type,
            pc.Payment_amount
        FROM
            payment pc
        WHERE
            pc.Order_id = '$order_id';
    ";
    $paymentResult = mysqli_query($conn, $paymentsQuery);

    $payments = [];
    if ($paymentResult && mysqli_num_rows($paymentResult) > 0) {
        while ($row = mysqli_fetch_assoc($paymentResult)) {
            $payments[] = [
                'paymentdate' => htmlspecialchars($row['Payment_date']),
                'paymenttype' => htmlspecialchars($row['Payment_type']),
                'amount' => htmlspecialchars($row['Payment_amount']),
            ];
        }
    }

    $order['order_data'] = $order_data;
    $order['payment'] = $payments;

    $response = [
        "status" => "success",
        "message" => "Order fetched successfully",
        "data" => $order
    ];
} else {
    $response["message"] = "Order not found for this user";
}

echo json_encode($response);
?>
